/*
 * Decompiled with CFR 0.152.
 */
package mcinterface1201;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexBuffer;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.imageio.ImageIO;
import mcinterface1201.ABuilderEntityBase;
import mcinterface1201.BuilderEntityExisting;
import mcinterface1201.BuilderEntityLinkedSeat;
import mcinterface1201.BuilderEntityRenderForwarder;
import mcinterface1201.WrapperItemStack;
import mcinterface1201.WrapperWorld;
import minecrafttransportsimulator.baseclasses.Point3D;
import minecrafttransportsimulator.baseclasses.TransformationMatrix;
import minecrafttransportsimulator.entities.components.AEntityC_Renderable;
import minecrafttransportsimulator.guis.components.AGUIBase;
import minecrafttransportsimulator.guis.components.GUIComponentItem;
import minecrafttransportsimulator.mcinterface.AWrapperWorld;
import minecrafttransportsimulator.mcinterface.IInterfaceRender;
import minecrafttransportsimulator.mcinterface.InterfaceManager;
import minecrafttransportsimulator.rendering.GIFParser;
import minecrafttransportsimulator.rendering.RenderableData;
import minecrafttransportsimulator.systems.ConfigSystem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.RegisterShadersEvent;
import org.joml.Matrix3f;
import org.joml.Matrix3fc;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;

public class InterfaceRender
implements IInterfaceRender {
    private static final Map<String, ResourceLocation> onlineTextures = new HashMap<String, ResourceLocation>();
    private static final Map<String, GIFParser.ParsedGIF> animatedGIFs = new HashMap<String, GIFParser.ParsedGIF>();
    private static final Map<GIFParser.ParsedGIF, Map<GIFParser.GIFImageFrame, ResourceLocation>> animatedGIFFrames = new LinkedHashMap<GIFParser.ParsedGIF, Map<GIFParser.GIFImageFrame, ResourceLocation>>();
    private static final List<GUIComponentItem> stacksToRender = new ArrayList<GUIComponentItem>();
    private static final ConcurrentHashMap<String, RenderType> renderTypes = new ConcurrentHashMap();
    private static final ConcurrentHashMap<RenderableData, BufferData> buffers = new ConcurrentHashMap();
    private static final ConcurrentHashMap<RenderType, List<RenderData>> queuedRenders = new ConcurrentHashMap();
    private static final ConcurrentLinkedQueue<BufferData> removedRenders = new ConcurrentLinkedQueue();
    private static final ResourceLocation BLOCK_TEXTURE_LOCATION = TextureAtlas.f_118259_;
    private static RenderStateShard.TextureStateShard MISSING_STATE;
    private static RenderStateShard.TextureStateShard BLOCK_STATE;
    public static PoseStack matrixStack;
    public static Matrix4f projectionMatrix;
    public static MultiBufferSource renderBuffer;
    public static Point3D renderCameraOffset;
    private static boolean renderingGUI;
    private static ShaderInstance entityLightsShader;
    private static ShaderInstance entityCutoutNoshadowsShader;
    private static final RenderStateShard.ShaderStateShard MTS_ENTITY_LIGHTS_SHADER;
    private static final RenderStateShard.ShaderStateShard MTS_ENTITY_CUTOUT_NOSHADOWS_SHADER;
    private static final RenderStateShard.TransparencyStateShard PROPER_TRANSLUCENT_TRANSPARENCY;
    private static final RenderStateShard.TransparencyStateShard BRIGHTNESS_TRANSPARENCY;

    public static void onIVRegisterShadersEvent(RegisterShadersEvent event) {
        try {
            event.registerShader(new ShaderInstance(event.getResourceProvider(), new ResourceLocation("mts", "mts_entity_lights"), DefaultVertexFormat.f_85812_), createdShader -> {
                entityLightsShader = createdShader;
            });
            event.registerShader(new ShaderInstance(event.getResourceProvider(), new ResourceLocation("mts", "mts_entity_cutout_noshadows"), DefaultVertexFormat.f_85812_), createdShader -> {
                entityCutoutNoshadowsShader = createdShader;
            });
        }
        catch (IOException e) {
            InterfaceManager.coreInterface.logError("COULD NOT LOAD SHADER FOR LIGHTS!  THIS WILL END BADLY FOR RENDERING!");
            e.printStackTrace();
        }
    }

    public static void onIVRegisterRenderersEvent(EntityRenderersEvent.RegisterRenderers event) {
        event.registerEntityRenderer((EntityType)BuilderEntityRenderForwarder.E_TYPE4.get(), manager -> new EntityRenderer<BuilderEntityRenderForwarder>(manager){

            public ResourceLocation getTextureLocation(BuilderEntityRenderForwarder builder) {
                return null;
            }

            public boolean shouldRender(BuilderEntityRenderForwarder builder, Frustum camera, double camX, double camY, double camZ) {
                return true;
            }

            public void render(BuilderEntityRenderForwarder builder, float entityYaw, float partialTicks, PoseStack stack, MultiBufferSource buffer, int packedLight) {
                if (builder.playerFollowing == Minecraft.m_91087_().f_91074_ && !((Boolean)ConfigSystem.settings.general.forceRenderLastSolid.value).booleanValue()) {
                    renderCameraOffset.set(Mth.m_14139_((double)partialTicks, (double)builder.f_19790_, (double)builder.m_20185_()), Mth.m_14139_((double)partialTicks, (double)builder.f_19791_, (double)builder.m_20186_()), Mth.m_14139_((double)partialTicks, (double)builder.f_19792_, (double)builder.m_20189_()));
                    matrixStack = stack;
                    renderBuffer = buffer;
                    InterfaceRender.doRenderCall(false, partialTicks);
                }
            }
        });
        event.registerEntityRenderer((EntityType)BuilderEntityExisting.E_TYPE2.get(), manager -> new BlankRender(manager));
        event.registerEntityRenderer((EntityType)BuilderEntityLinkedSeat.E_TYPE3.get(), manager -> new BlankRender(manager));
    }

    @Override
    public float[] getBlockBreakTexture(AWrapperWorld world, Point3D position) {
        BlockPos pos = BlockPos.m_274561_((double)position.x, (double)position.y, (double)position.z);
        BlockState state = ((WrapperWorld)world).world.m_8055_(pos);
        TextureAtlasSprite sprite = Minecraft.m_91087_().m_91289_().m_110907_().getTexture(state, ((WrapperWorld)world).world, pos);
        return new float[]{sprite.m_118409_(), sprite.m_118410_(), sprite.m_118411_(), sprite.m_118412_()};
    }

    @Override
    public float[] getDefaultBlockTexture(String name) {
        TextureAtlasSprite sprite = Minecraft.m_91087_().m_91289_().m_110907_().m_110881_().m_119428_(BLOCK_TEXTURE_LOCATION).m_118316_(new ResourceLocation(name.replace(":", ":blocks/")));
        return new float[]{sprite.m_118409_(), sprite.m_118410_(), sprite.m_118411_(), sprite.m_118412_()};
    }

    @Override
    public String getDefaultFontTextureFolder() {
        return "/assets/mts/textures/mcfont";
    }

    @Override
    public InputStream getTextureStream(String name) {
        try {
            String domain = name.substring("/assets/".length(), name.indexOf("/", "/assets/".length()));
            String location = name.substring("/assets/".length() + domain.length() + 1);
            return ((Resource)Minecraft.m_91087_().m_91098_().m_213713_(new ResourceLocation(domain, location)).get()).m_215507_();
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public void renderItemModel(GUIComponentItem component) {
        stacksToRender.add(component);
    }

    @Override
    public void renderVertices(RenderableData data, boolean changedSinceLastRender) {
        matrixStack.m_85836_();
        Matrix4f matrix4f = InterfaceRender.convertMatrix4f(data.transform);
        Matrix3f matrix3f = new Matrix3f((Matrix4fc)matrix4f);
        PoseStack.Pose stackEntry = matrixStack.m_85850_();
        stackEntry.m_252922_().mul((Matrix4fc)matrix4f);
        if (data.vertexObject.isLines) {
            stackEntry.m_252943_().mul((Matrix3fc)matrix3f);
            VertexConsumer buffer = renderBuffer.m_6299_(RenderType.m_110504_());
            while (data.vertexObject.vertices.hasRemaining()) {
                buffer.m_252986_(stackEntry.m_252922_(), data.vertexObject.vertices.get(), data.vertexObject.vertices.get(), data.vertexObject.vertices.get());
                buffer.m_85950_(data.color.red, data.color.green, data.color.blue, data.alpha);
                buffer.m_252939_(stackEntry.m_252943_(), 0.0f, 0.0f, 1.0f);
                buffer.m_5752_();
            }
            data.vertexObject.vertices.rewind();
        } else {
            String typeID = data.texture + data.isTranslucent + data.lightingMode + data.enableBrightBlending;
            if (data.vertexObject.cacheVertices && !renderingGUI && (Integer)ConfigSystem.client.renderingSettings.renderingMode.value != 2) {
                List<RenderData> renders;
                RenderType renderType = renderTypes.computeIfAbsent(typeID, k -> CustomRenderType.m_173215_((String)"mts_entity", (VertexFormat)DefaultVertexFormat.f_85812_, (VertexFormat.Mode)VertexFormat.Mode.TRIANGLES, (int)0x200000, (boolean)true, (boolean)data.isTranslucent, (RenderType.CompositeState)CustomRenderType.createForObject(data).m_110691_(false)));
                BufferData bufferData = buffers.computeIfAbsent(data, k -> new BufferData(renderType, data));
                if (changedSinceLastRender) {
                    bufferData.builder.m_85729_();
                    bufferData.isReady = false;
                }
                if (!bufferData.isReady) {
                    bufferData.builder.m_166779_(VertexFormat.Mode.TRIANGLES, renderType.m_110508_());
                    while (data.vertexObject.vertices.hasRemaining()) {
                        float normalX = data.vertexObject.vertices.get();
                        float normalY = data.vertexObject.vertices.get();
                        float normalZ = data.vertexObject.vertices.get();
                        float texU = data.vertexObject.vertices.get();
                        float texV = data.vertexObject.vertices.get();
                        float posX = data.vertexObject.vertices.get();
                        float posY = data.vertexObject.vertices.get();
                        float posZ = data.vertexObject.vertices.get();
                        bufferData.builder.m_5954_(posX, posY, posZ, data.color.red, data.color.green, data.color.blue, data.alpha, texU, texV, OverlayTexture.f_118083_, data.worldLightValue, normalX, normalY, normalZ);
                    }
                    bufferData.isReady = true;
                    bufferData.buffer.m_85921_();
                    bufferData.buffer.m_231221_(bufferData.builder.m_231175_());
                    data.vertexObject.vertices.rewind();
                    VertexBuffer.m_85931_();
                }
                if ((renders = queuedRenders.get(renderType)) == null) {
                    renders = new ArrayList<RenderData>();
                    queuedRenders.put(renderType, renders);
                }
                renders.add(new RenderData(stackEntry.m_252922_(), bufferData));
            } else {
                stackEntry.m_252943_().mul((Matrix3fc)matrix3f);
                RenderType renderType = renderTypes.computeIfAbsent(typeID, k -> CustomRenderType.m_173215_((String)("mts_entity_" + typeID), (VertexFormat)DefaultVertexFormat.f_85812_, (VertexFormat.Mode)VertexFormat.Mode.TRIANGLES, (int)256, (boolean)true, (boolean)data.isTranslucent, (RenderType.CompositeState)CustomRenderType.createForObject(data).m_110691_(false)));
                VertexConsumer buffer = renderBuffer.m_6299_(renderType);
                while (data.vertexObject.vertices.hasRemaining()) {
                    float normalX = data.vertexObject.vertices.get();
                    float normalY = data.vertexObject.vertices.get();
                    float normalZ = data.vertexObject.vertices.get();
                    float texU = data.vertexObject.vertices.get();
                    float texV = data.vertexObject.vertices.get();
                    float posX = data.vertexObject.vertices.get();
                    float posY = data.vertexObject.vertices.get();
                    float posZ = data.vertexObject.vertices.get();
                    buffer.m_252986_(stackEntry.m_252922_(), posX, posY, posZ);
                    buffer.m_85950_(data.color.red, data.color.green, data.color.blue, data.alpha);
                    buffer.m_7421_(texU, texV);
                    buffer.m_86008_(OverlayTexture.f_118083_);
                    buffer.m_85969_(data.worldLightValue);
                    buffer.m_252939_(stackEntry.m_252943_(), normalX, normalY, normalZ);
                    buffer.m_5752_();
                }
                data.vertexObject.vertices.rewind();
            }
        }
        matrixStack.m_85849_();
    }

    public static void doRenderCall(boolean blendingEnabled, float partialTicks) {
        AWrapperWorld world = InterfaceManager.clientInterface.getClientWorld();
        ConcurrentLinkedQueue allEntities = world.renderableEntities;
        if (allEntities != null) {
            world.beginProfiling("MTSRendering_Setup", true);
            for (AEntityC_Renderable entity : allEntities) {
                matrixStack.m_85836_();
                matrixStack.m_85837_(entity.position.x - InterfaceRender.renderCameraOffset.x, entity.position.y - InterfaceRender.renderCameraOffset.y, entity.position.z - InterfaceRender.renderCameraOffset.z);
                entity.render(blendingEnabled, partialTicks);
                matrixStack.m_85849_();
            }
            if (!queuedRenders.isEmpty()) {
                world.beginProfiling("MTSRendering_Batch", false);
                InterfaceRender.renderBuffers(partialTicks);
                world.endProfiling();
            }
        }
    }

    private static void renderBuffers(float partialTicks) {
        for (Map.Entry<RenderType, List<RenderData>> renderEntry : queuedRenders.entrySet()) {
            RenderType renderType = renderEntry.getKey();
            List<RenderData> datas = renderEntry.getValue();
            if (!datas.isEmpty() && (Integer)ConfigSystem.client.renderingSettings.renderingMode.value == 0) {
                renderType.m_110185_();
                ShaderInstance shaderInstance = RenderSystem.getShader();
                for (int k = 0; k < 12; ++k) {
                    int i = RenderSystem.getShaderTexture((int)k);
                    shaderInstance.m_173350_("Sampler" + k, (Object)i);
                }
                if (shaderInstance.f_173309_ != null) {
                    shaderInstance.f_173309_.m_5679_(projectionMatrix);
                }
                if (shaderInstance.f_200956_ != null) {
                    shaderInstance.f_200956_.m_200759_(RenderSystem.getInverseViewRotationMatrix());
                }
                if (shaderInstance.f_173312_ != null) {
                    shaderInstance.f_173312_.m_5941_(RenderSystem.getShaderColor());
                }
                if (shaderInstance.f_173315_ != null) {
                    shaderInstance.f_173315_.m_5985_(RenderSystem.getShaderFogStart());
                }
                if (shaderInstance.f_173316_ != null) {
                    shaderInstance.f_173316_.m_5985_(RenderSystem.getShaderFogEnd());
                }
                if (shaderInstance.f_173317_ != null) {
                    shaderInstance.f_173317_.m_5941_(RenderSystem.getShaderFogColor());
                }
                if (shaderInstance.f_202432_ != null) {
                    shaderInstance.f_202432_.m_142617_(RenderSystem.getShaderFogShape().m_202324_());
                }
                RenderSystem.setupShaderLights((ShaderInstance)shaderInstance);
                for (RenderData data : datas) {
                    if (shaderInstance.f_173308_ != null) {
                        shaderInstance.f_173308_.m_5679_(data.matrix);
                    }
                    shaderInstance.m_173363_();
                    data.bufferData.buffer.m_85921_();
                    data.bufferData.buffer.m_166882_();
                }
                VertexBuffer.m_85931_();
                shaderInstance.m_173362_();
                renderType.m_110188_();
                datas.clear();
            }
            if (datas.isEmpty()) continue;
            renderType.m_110185_();
            for (RenderData data : datas) {
                data.bufferData.buffer.m_85921_();
                data.bufferData.buffer.m_253207_(data.matrix, projectionMatrix, RenderSystem.getShader());
            }
            VertexBuffer.m_85931_();
            renderType.m_110188_();
            datas.clear();
        }
        if (!removedRenders.isEmpty()) {
            removedRenders.forEach(render -> render.buffer.close());
            removedRenders.clear();
        }
    }

    @Override
    public void deleteVertices(RenderableData data) {
        BufferData buffer;
        if (data.vertexObject.cacheVertices && (buffer = buffers.remove(data)) != null) {
            removedRenders.add(buffer);
        }
    }

    @Override
    public int getLightingAtPosition(Point3D position) {
        BlockPos pos = BlockPos.m_274561_((double)position.x, (double)position.y, (double)position.z);
        return LightTexture.m_109885_((int)Minecraft.m_91087_().f_91073_.m_45517_(LightLayer.BLOCK, pos), (int)Minecraft.m_91087_().f_91073_.m_45517_(LightLayer.SKY, pos));
    }

    @Override
    public boolean shouldRenderBoundingBoxes() {
        return Minecraft.m_91087_().m_91290_().m_114377_();
    }

    @Override
    public boolean bindURLTexture(String textureURL, InputStream stream) {
        if (stream != null) {
            try {
                NativeImage image = NativeImage.m_85048_((NativeImage.Format)NativeImage.Format.RGB, (InputStream)stream);
                DynamicTexture texture = new DynamicTexture(image);
                ResourceLocation textureLocation = Minecraft.m_91087_().f_90987_.m_118490_("mts-url", texture);
                onlineTextures.put(textureURL, textureLocation);
                return true;
            }
            catch (Exception e) {
                return false;
            }
        }
        onlineTextures.put(textureURL, null);
        return true;
    }

    @Override
    public boolean bindURLGIF(String textureURL, GIFParser.ParsedGIF gif) {
        HashMap<GIFParser.GIFImageFrame, ResourceLocation> gifFrameIndexes = new HashMap<GIFParser.GIFImageFrame, ResourceLocation>();
        for (GIFParser.GIFImageFrame frame : gif.frames.values()) {
            try {
                BufferedImage frameBuffer = frame.getImage();
                ByteArrayOutputStream frameArrayStream = new ByteArrayOutputStream();
                ImageIO.write((RenderedImage)frameBuffer, "gif", frameArrayStream);
                ByteArrayInputStream frameStream = new ByteArrayInputStream(frameArrayStream.toByteArray());
                NativeImage image = NativeImage.m_85048_((NativeImage.Format)NativeImage.Format.RGB, (InputStream)frameStream);
                DynamicTexture texture = new DynamicTexture(image);
                ResourceLocation textureLocation = Minecraft.m_91087_().f_90987_.m_118490_("mts-gif", texture);
                gifFrameIndexes.put(frame, textureLocation);
            }
            catch (Exception e) {
                return false;
            }
        }
        animatedGIFs.put(textureURL, gif);
        animatedGIFFrames.put(gif, gifFrameIndexes);
        return true;
    }

    private static RenderStateShard.TextureStateShard getTexture(String textureLocation) {
        if (MISSING_STATE == null) {
            MISSING_STATE = new RenderStateShard.TextureStateShard(new ResourceLocation("mts:textures/rendering/missing.png"), false, false);
            BLOCK_STATE = new RenderStateShard.TextureStateShard(BLOCK_TEXTURE_LOCATION, false, false);
        }
        if (animatedGIFs.containsKey(textureLocation)) {
            GIFParser.ParsedGIF parsedGIF = animatedGIFs.get(textureLocation);
            return new RenderStateShard.TextureStateShard(animatedGIFFrames.get(parsedGIF).get(parsedGIF.getCurrentFrame()), false, false);
        }
        if (onlineTextures.containsKey(textureLocation)) {
            ResourceLocation onlineTexture = onlineTextures.get(textureLocation);
            return onlineTexture != null ? new RenderStateShard.TextureStateShard(onlineTextures.get(textureLocation), false, false) : MISSING_STATE;
        }
        if (textureLocation.equals("GLOBAL")) {
            return BLOCK_STATE;
        }
        Object formattedLocation = textureLocation;
        if (textureLocation.contains(":")) {
            formattedLocation = "/assets/" + textureLocation.replace(":", "/");
        }
        if (InterfaceManager.coreInterface.getPackResource((String)formattedLocation) != null) {
            String domain = ((String)formattedLocation).substring("/assets/".length(), ((String)formattedLocation).indexOf("/", "/assets/".length()));
            String location = ((String)formattedLocation).substring("/assets/".length() + domain.length() + 1);
            return new RenderStateShard.TextureStateShard(new ResourceLocation(domain, location), false, false);
        }
        InterfaceManager.coreInterface.logError("Could not find texture: " + (String)formattedLocation + " Reverting to fallback texture.");
        return MISSING_STATE;
    }

    protected static void renderGUI(GuiGraphics mcGUI, int mouseX, int mouseY, int screenWidth, int screenHeight, float partialTicks, boolean updateGUIs) {
        matrixStack = mcGUI.m_280168_();
        matrixStack.m_85836_();
        renderingGUI = true;
        MultiBufferSource.BufferSource guiBuffer = MultiBufferSource.m_109898_((BufferBuilder)Tesselator.m_85913_().m_85915_());
        renderBuffer = guiBuffer;
        matrixStack.m_85841_(1.0f, -1.0f, 1.0f);
        int displayGUIIndex = 0;
        for (AGUIBase gui : AGUIBase.activeGUIs) {
            if (updateGUIs || gui.components.isEmpty()) {
                gui.setupComponentsInit(screenWidth, screenHeight);
            }
            matrixStack.m_85836_();
            if (gui.capturesPlayer()) {
                matrixStack.m_252880_(0.0f, 0.0f, 250.0f);
            } else {
                matrixStack.m_252880_(0.0f, 0.0f, (float)(-500 + 250 * displayGUIIndex++));
            }
            gui.render(mouseX, mouseY, false, partialTicks);
            guiBuffer.m_109911_();
            RenderSystem.enableBlend();
            gui.render(mouseX, mouseY, true, partialTicks);
            guiBuffer.m_109911_();
            RenderSystem.disableBlend();
            matrixStack.m_85841_(1.0f, -1.0f, 1.0f);
            for (GUIComponentItem component : stacksToRender) {
                if ((WrapperItemStack)component.stackToRender == null) continue;
                PoseStack posestack = RenderSystem.getModelViewStack();
                posestack.m_85836_();
                posestack.m_252880_(0.0f, 0.0f, (float)(component.translation.z - 100.0));
                if ((double)component.scale != 1.0) {
                    posestack.m_85841_(component.scale, component.scale, 1.0f);
                    RenderSystem.applyModelViewMatrix();
                    mcGUI.m_280480_(((WrapperItemStack)component.stackToRender).stack, (int)(component.translation.x / (double)component.scale), (int)(-component.translation.y / (double)component.scale) + 1);
                } else {
                    RenderSystem.applyModelViewMatrix();
                    mcGUI.m_280480_(((WrapperItemStack)component.stackToRender).stack, (int)component.translation.x, (int)(-component.translation.y));
                }
                posestack.m_85849_();
                RenderSystem.applyModelViewMatrix();
            }
            stacksToRender.clear();
            matrixStack.m_85849_();
        }
        matrixStack.m_85849_();
        renderingGUI = false;
    }

    public static Matrix4f convertMatrix4f(TransformationMatrix transform) {
        return new Matrix4f((float)transform.m00, (float)transform.m10, (float)transform.m20, (float)transform.m30, (float)transform.m01, (float)transform.m11, (float)transform.m21, (float)transform.m31, (float)transform.m02, (float)transform.m12, (float)transform.m22, (float)transform.m32, (float)transform.m03, (float)transform.m13, (float)transform.m23, (float)transform.m33);
    }

    static {
        renderCameraOffset = new Point3D();
        MTS_ENTITY_LIGHTS_SHADER = new RenderStateShard.ShaderStateShard(() -> entityLightsShader);
        MTS_ENTITY_CUTOUT_NOSHADOWS_SHADER = new RenderStateShard.ShaderStateShard(() -> entityCutoutNoshadowsShader);
        PROPER_TRANSLUCENT_TRANSPARENCY = new RenderStateShard.TransparencyStateShard("proper_translucent_transparency", () -> {
            RenderSystem.enableBlend();
            RenderSystem.depthMask((boolean)false);
            RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        }, () -> {
            RenderSystem.disableBlend();
            RenderSystem.depthMask((boolean)true);
            RenderSystem.defaultBlendFunc();
        });
        BRIGHTNESS_TRANSPARENCY = new RenderStateShard.TransparencyStateShard("brightness_transparency", () -> {
            RenderSystem.enableBlend();
            RenderSystem.depthMask((boolean)false);
            RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.DST_COLOR, (GlStateManager.DestFactor)GlStateManager.DestFactor.SRC_ALPHA);
        }, () -> {
            RenderSystem.disableBlend();
            RenderSystem.depthMask((boolean)true);
            RenderSystem.defaultBlendFunc();
        });
    }

    private static class BufferData {
        final BufferBuilder builder;
        final VertexBuffer buffer;
        boolean isReady;

        private BufferData() {
            this.builder = null;
            this.buffer = null;
        }

        private BufferData(RenderType type, RenderableData data) {
            int vertices = data.vertexObject.vertices.limit() / 8;
            vertices = (vertices / 3 + 1) * 3;
            this.builder = new BufferBuilder(type.m_110508_().m_86017_() * vertices);
            this.buffer = new VertexBuffer(VertexBuffer.Usage.STATIC);
        }
    }

    private static class RenderData {
        private final Matrix4f matrix;
        private final BufferData bufferData;

        private RenderData(Matrix4f matrix, BufferData bufferData) {
            this.matrix = new Matrix4f((Matrix4fc)matrix);
            this.bufferData = bufferData;
        }
    }

    private static class CustomRenderType
    extends RenderType {
        private CustomRenderType(String name, VertexFormat fmt, VertexFormat.Mode glMode, int size, boolean doCrumbling, boolean depthSorting, Runnable onEnable, Runnable onDisable) {
            super(name, fmt, glMode, size, doCrumbling, depthSorting, onEnable, onDisable);
            throw new IllegalStateException("This class must not be instantiated, this is only here to gain access to the rendering constants.");
        }

        private static RenderType.CompositeState.CompositeStateBuilder createForObject(RenderableData data) {
            RenderType.CompositeState.CompositeStateBuilder stateBuilder = RenderType.CompositeState.m_110628_();
            if (data.lightingMode.disableTextureShadows) {
                if (data.lightingMode.disableWorldLighting) {
                    stateBuilder.m_173292_(MTS_ENTITY_LIGHTS_SHADER);
                } else {
                    stateBuilder.m_173292_(MTS_ENTITY_CUTOUT_NOSHADOWS_SHADER);
                }
            } else if (data.isTranslucent) {
                stateBuilder.m_173292_(f_173112_);
            } else {
                stateBuilder.m_173292_(f_173113_);
            }
            if (data.enableBrightBlending) {
                stateBuilder.m_110685_(BRIGHTNESS_TRANSPARENCY);
            } else if (data.isTranslucent) {
                stateBuilder.m_110685_(PROPER_TRANSLUCENT_TRANSPARENCY);
            } else {
                stateBuilder.m_110685_(f_110134_);
            }
            stateBuilder.m_173290_((RenderStateShard.EmptyTextureStateShard)(data.texture != null ? InterfaceRender.getTexture(data.texture) : f_110147_));
            stateBuilder.m_110671_(f_110152_);
            stateBuilder.m_110675_(f_110123_);
            stateBuilder.m_110677_(f_110154_);
            stateBuilder.m_110661_(f_110158_);
            return stateBuilder;
        }
    }

    private static class BlankRender<T extends ABuilderEntityBase>
    extends EntityRenderer<T> {
        protected BlankRender(EntityRendererProvider.Context p_i46179_1_) {
            super(p_i46179_1_);
        }

        public ResourceLocation getTextureLocation(T pEntity) {
            return null;
        }

        public boolean shouldRender(T builder, Frustum camera, double camX, double camY, double camZ) {
            return false;
        }
    }
}

